/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.deployment.TransactionalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import java.util.function.Consumer;

public class DefaultPolicyDeploymentService
implements PolicyDeploymentService {
    private final ApiService apiService;
    private final TransactionalPolicyDeployer policyDeployer;
    private final PolicyDeploymentTracker policyDeploymentTracker;

    public DefaultPolicyDeploymentService(ApiService apiService, PolicyDeploymentTracker policyDeploymentTracker, TransactionalPolicyDeployer policyDeployer) {
        this.apiService = apiService;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyDeployer = policyDeployer;
    }

    @Override
    public void newPolicy(PolicyDefinition policy) {
        this.forAllApis(policy, api -> this.policyDeployer.deploy(policy, (Api)api));
    }

    @Override
    public void updatePolicy(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy) {
        this.forAllApis(updatedPolicy, api -> this.policyDeployer.update(oldPolicy, updatedPolicy, (Api)api));
    }

    @Override
    public void revertPolicy(PolicyDefinition policy) {
        this.forAllApis(policy, api -> this.policyDeployer.revertPolicy(policy, (Api)api));
    }

    @Override
    public void reorderPolicy(PolicyDefinition oldPolicy, PolicyDefinition reorderedPolicy) {
        this.forAllApis(reorderedPolicy, api -> this.policyDeployer.updateOrder(oldPolicy, reorderedPolicy, (Api)api));
    }

    @Override
    public void removePolicy(PolicyDefinition policy) {
        this.forAllApis(policy, api -> this.policyDeployer.undeploy(policy.getName(), (Api)api));
    }

    @Override
    public void removePolicy(String policyName) {
        this.policyDeploymentTracker.findByName(policyName).ifPresent(this::removePolicy);
    }

    private void forAllApis(PolicyDefinition policyDefinition, Consumer<Api> consumer) {
        policyDefinition.getApiKeys().forEach(key -> this.apiService.get(key).ifPresent(consumer));
    }
}

