/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies;

import static java.util.Collections.emptyMap;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;

import java.util.Collections;
import java.util.Map;

/**
 * Contains the triplet that defines a policy. Each policy comes from a {@link PolicyTemplate}, and with the
 * {@link PolicyDefinition} we can resolve the template with the configuration data. The final result of the process is also
 * stored within this class.
 */
public class Policy {

  private PolicyDefinition policyDefinition;
  private String resolvedTemplate;
  private PolicyTemplate policyTemplate;
  private Map<String, Object> configFile;

  public Policy(PolicyTemplate policyTemplate, PolicyDefinition policyDefinition, String resolvedTemplate) {
    this(policyTemplate, policyDefinition, resolvedTemplate, null);
  }

  public Policy(PolicyTemplate policyTemplate, PolicyDefinition policyDefinition, String resolvedTemplate,
                Map<String, Object> configFile) {
    this.policyTemplate = policyTemplate;
    this.policyDefinition = policyDefinition;
    this.resolvedTemplate = resolvedTemplate;
    this.configFile = configFile != null ? configFile : emptyMap();
  }

  public PolicyTemplate getPolicyTemplate() {
    return policyTemplate;
  }

  public PolicyDefinition getPolicyDefinition() {
    return policyDefinition;
  }

  public String getResolvedTemplate() {
    return resolvedTemplate;
  }

  public Map<String, Object> getConfigFile() {
    return configFile;
  }
}
