/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies;

import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED;
import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS;
import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.Objects;

public class PolicyDefinitionDeploymentStatus {

  private final Exception exception;

  // NOTE: This field must not be removed as long as TITA relies on it for determining if a policy was deployed successfully or
  // not.
  private final PolicyDefinition policyDefinition;
  protected final DeploymentStatus deploymentStatus;

  public PolicyDefinitionDeploymentStatus(PolicyDefinition policy) {
    this(policy, DEPLOYMENT_SUCCESS, null);
  }

  public PolicyDefinitionDeploymentStatus(PolicyDefinition policyDefinition, DeploymentStatus applied, Exception e) {
    this.policyDefinition = policyDefinition;
    this.deploymentStatus = applied;
    this.exception = e;
  }

  public boolean isDeploymentSuccess() {
    return DEPLOYMENT_SUCCESS.equals(deploymentStatus);
  }

  public boolean isTemplateDownloadFailed() {
    return TEMPLATE_DOWNLOAD_FAILED.equals(deploymentStatus);
  }

  public boolean isDeploymentFailed() {
    return DEPLOYMENT_FAILED.equals(deploymentStatus);
  }

  public Exception getException() {
    return exception;
  }

  public PolicyDefinition getPolicyDefinition() {
    return policyDefinition;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    PolicyDefinitionDeploymentStatus that = (PolicyDefinitionDeploymentStatus) o;
    return Objects.equals(exception, that.exception) && policyDefinition.equals(that.policyDefinition)
        && deploymentStatus == that.deploymentStatus;
  }

  @Override
  public int hashCode() {
    return Objects.hash(exception, policyDefinition, deploymentStatus);
  }

  public enum DeploymentStatus {
    DEPLOYMENT_SUCCESS, DEPLOYMENT_FAILED, TEMPLATE_DOWNLOAD_FAILED
  }
}
