/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies;

import static java.util.Optional.of;
import static java.util.Optional.ofNullable;

import java.util.Objects;
import java.util.Optional;

/**
 * Represents the state for a policy. This is composed of two status, the status of the policy that is currently applied and the
 * status for the policy that should be applied. If there wasn't any deployment issue, they will be the same.
 */

// TODO: (AGW-1369) Review the Policy model
public class PolicyDeploymentStatus {

  private final PolicyDefinitionDeploymentStatus latestPolicyStatus;
  private final Optional<PolicyDefinitionDeploymentStatus> appliedPolicyStatus;

  public PolicyDeploymentStatus(PolicyDefinitionDeploymentStatus latestPolicyStatus,
                                Optional<PolicyDefinitionDeploymentStatus> appliedPolicyStatus) {
    this.latestPolicyStatus = latestPolicyStatus;
    this.appliedPolicyStatus = appliedPolicyStatus;
  }

  public PolicyDeploymentStatus(PolicyDefinitionDeploymentStatus latestPolicyStatus) {
    this(latestPolicyStatus, of(latestPolicyStatus));
  }

  /**
   * @return the deployment status of the policy with the latest policy definition. This definition mirroring the one from the
   *         platform. This is the Policy deployment status for the policy definition that SHOULD be applied.
   */
  public PolicyDefinitionDeploymentStatus getLatestPolicyStatus() {
    return latestPolicyStatus;
  }

  /**
   * @return the deployment status of the policy definition that is currently applied. This might differ with latest policy status
   *         if there was a problem during a policy edition. This is the Policy deployment status for the policy definition that
   *         IS applied.
   */
  public Optional<PolicyDefinitionDeploymentStatus> getAppliedPolicyStatus() {
    return appliedPolicyStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    PolicyDeploymentStatus status = (PolicyDeploymentStatus) o;
    return latestPolicyStatus.equals(status.latestPolicyStatus) &&
        appliedPolicyStatus.equals(status.appliedPolicyStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(latestPolicyStatus, appliedPolicyStatus);
  }

}
