/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;

/**
 * Encrypts values from the configuration of a policy taken from a {@link PolicyDefinition} It can handle simple Strings and Maps,
 * and each value encrypted must return an {@link EncryptedValueResult}
 */
public interface PolicyConfigurationEncrypter {

  /**
   * Process policy configuration and encrypts values if required. If anypoint.platform.enable_smart_encryption is set to true,
   * only those values marked as 'sensitive' should be encrypted. If the property is set to false, then all string and map
   * properties will be encrypted.
   *
   * @param policyDefinition The policy definition
   * @param policySpecification List of properties that should be encrypted if Smart Encryption is enabled
   * @return The result of the encryption
   */
  PolicyConfigurationEncryptionResult encryptConfiguration(PolicyDefinition policyDefinition,
                                                           PolicySpecification policySpecification);
}
