/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import static com.mulesoft.mule.runtime.gw.model.PolicyConfiguration.PROPERTY_ENCRYPTED;

import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;

import java.util.Map;

/**
 * Represents the result of the encryption of the configuration of a policy.
 *
 * Each encryption operation contains the map that will be populated in the XML template, and other map that contains the values
 * that defines the configuration of the same policy instance.
 *
 * Both maps can be the same if there is no encryption feature available.
 */
public class PolicyConfigurationEncryptionResult {

  private Map<String, Object> templatePlaceholders;
  private PolicyConfiguration configurationProperties;
  private Map<String, Object> configFileProperties;

  public PolicyConfigurationEncryptionResult(Map<String, Object> templatePlaceholders,
                                             PolicyConfiguration configurationProperties,
                                             Map<String, Object> configFileProperties) {
    this.templatePlaceholders = templatePlaceholders;
    flagEncryptedConfiguration(templatePlaceholders, configurationProperties);
    this.configurationProperties = configurationProperties;
    this.configFileProperties = configFileProperties;
  }

  private void flagEncryptedConfiguration(Map<String, Object> templatePlaceholders, PolicyConfiguration configurationProperties) {
    Object encrypted = templatePlaceholders.get(PROPERTY_ENCRYPTED);
    configurationProperties.setEncrypted(Boolean.valueOf(String.valueOf(encrypted)));
  }

  public Map<String, Object> getTemplatePlaceholders() {
    return templatePlaceholders;
  }

  public PolicyConfiguration getConfigurationProperties() {
    return configurationProperties;
  }

  public Map<String, Object> getConfigFileProperties() {
    return configFileProperties;
  }
}
