/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import static java.lang.String.join;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.KeyvalueTypeFilter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Knows how to encrypt and decrypt single config values with type keyvalue
 */
public class KeyvalueEncrypter extends PolicyTypeEncrypter<Map<String, Object>> {

  public KeyvalueEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled,
                           List<PolicyProperty> policyProperties) {
    super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
  }

  @Override
  protected EncryptedValueResult encryptSingle(String rootKey, Map<String, Object> keyvalue) {
    Map<String, Object> configurationMap = new HashMap<>();

    String key = (String) keyvalue.get("key");
    String value = (String) keyvalue.get("value");
    String encrypted = encrypt(value);

    String templateValue = join("", TEMPLATE_PREFIX, rootKey, ".", key, TEMPLATE_SUFFIX);
    Map<String, Object> templateMap = new LinkedHashMap<>();
    templateMap.put("key", key);
    templateMap.put("value", templateValue);

    configurationMap.put("key", key);
    configurationMap.put("value", encrypted);

    return new EncryptedValueResult<>(rootKey, templateMap, configurationMap, configurationMap);
  }

  @Override
  protected EncryptedValueResult decryptSingle(String key, Map<String, Object> keyvalue) {
    Map<Object, Object> decrypted = new HashMap<>();
    decrypted.put("key", keyvalue.get("key"));
    decrypted.put("value", decrypt((String) keyvalue.get("value")));

    return new EncryptedValueResult<>(key, decrypted, decrypted);
  }

  @Override
  protected boolean supports(String key, Optional<PolicyProperty> property) {
    return property.isPresent() && new KeyvalueTypeFilter().test(property.get());
  }

}
