/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import static java.util.Collections.emptyList;

import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;

import java.util.Optional;

public class NullEncrypter extends PolicyTypeEncrypter<Object> {

  public NullEncrypter() {
    super(null, false, emptyList());
  }

  @Override
  protected EncryptedValueResult encryptSingle(String key, Object value) {
    return new EncryptedValueResult<>(key, value, value);
  }

  @Override
  protected EncryptedValueResult decryptSingle(String key, Object value) {
    return new EncryptedValueResult<>(key, value, value);
  }

  @Override
  protected boolean supports(String key, Optional<PolicyProperty> property) {
    return true;
  }

}
