/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.filter;

import com.mulesoft.mule.runtime.gw.model.PolicyProperty;

/**
 * Filters properties that match with the same types as {@link StringTypeFilter} in an array format.
 *
 * This filter is used when the encryption feature is enabled.
 */
public class StringListTypeFilter extends StringTypeFilter {

  @Override
  public boolean test(PolicyProperty policyProperty) {
    return VALID_STRINGS.contains(policyProperty.getType()) && policyProperty.getAllowMultiple();
  }
}
