/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.filter;

import static com.google.common.collect.ImmutableList.of;

import com.mulesoft.mule.runtime.gw.model.PolicyProperty;

import java.util.List;
import java.util.function.Predicate;

/**
 * Filters properties that match with one of the following custom YAML types: - Expressions - Strings - URL - IpAdress
 *
 * This filter is used when the encryption feature is enabled.
 */
public class StringTypeFilter implements Predicate<PolicyProperty> {

  static final List<String> VALID_STRINGS = of("expression", "string", "url", "ipaddress");

  @Override
  public boolean test(PolicyProperty policyProperty) {
    return VALID_STRINGS.contains(policyProperty.getType()) && !policyProperty.getAllowMultiple();
  }
}
