/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;

/**
 * Factory for {@link Policy}
 */
public interface PolicyFactory {

  /**
   * Creates a new {@link Policy} according to the {@link PolicyDefinition}
   *
   * @param policyDefinition The definition of the policy
   * @return a new policy
   */
  Policy createFromPolicyDefinition(PolicyDefinition policyDefinition);

}
