/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.STRICT;
import static java.util.Optional.empty;
import static java.util.Optional.of;

import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.DefaultPolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.ClasspathPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.HandlebarsPolicyTemplateResolver;

import java.util.Optional;
import java.util.function.Supplier;

import org.slf4j.Logger;

public class GateKeeperSupplier implements Supplier<Optional<GateKeeper>> {

  private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(GateKeeper.class);

  private final GateKeeperConfiguration configuration;
  private final ApiService apiService;
  private final PolicyFactory policyFactory;

  public GateKeeperSupplier(GateKeeperConfiguration configuration,
                            ApiService apiService) {
    this.configuration = configuration;
    this.apiService = apiService;
    this.policyFactory = new DefaultPolicyFactory(new HandlebarsPolicyTemplateResolver(),
                                                  new ClasspathPolicyTemplateProvider());
  }

  public Optional<GateKeeper> get() {
    Optional<GateKeeper> gateKeeper = empty();
    Mode gateKeeperMode = configuration.mode();

    if (configuration.isEnabled()) {
      LOGGER.info("GateKeeper started in {} mode", gateKeeperMode);
      gateKeeper =
          of(configuration.mode().equals(STRICT) ? new StrictGateKeeper(apiService, policyFactory)
              : new FlexibleGateKeeper(apiService, policyFactory));
    } else {
      LOGGER.info("GateKeeper is disabled.");
    }

    return gateKeeper;
  }

}
