/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;

/**
 * Implementation of Strict mode GateKeeper.
 */
public class StrictGateKeeper extends BlockingGateKeeper {

  public StrictGateKeeper(ApiService apiService,
                          PolicyFactory policyFactory) {
    super(apiService, policyFactory);
  }

  @Override
  protected boolean validOrigin(PolicySet set) {
    return set.isFromPlatform();
  }
}
