/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck;

import static java.util.Optional.of;

import org.mule.runtime.api.healthcheck.ReadyStatus;

import java.util.Optional;

public class DefaultReadyStatus implements ReadyStatus {

  private final boolean ready;
  private final String description;

  public DefaultReadyStatus(boolean ready, String description) {
    this.ready = ready;
    this.description = description;
  }

  @Override
  public boolean isReady() {
    return ready;
  }

  @Override
  public Optional<String> statusDescription() {
    return of(description);
  }
}
