/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle.healthcheck;

import org.mule.runtime.api.healthcheck.ReadyStatus;

import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;

import java.util.List;

/**
 * A factory to create {@link ReadyStatus} belonging to an App.
 */
public interface ReadyStatusFactory {

  /**
   * @param apiId Id of the API that corresponds with the status.
   * @param gatekeeperStatus status of the api.
   * @return a {@link ReadyStatus} with the message according to the current status.
   */
  ReadyStatus readyStatus(Long apiId, GatekeeperStatus gatekeeperStatus);

  /**
   * Given a list of {@link ReadyStatus} this method creates a new Ready Status that is the composition of all of them.
   *
   * @param readyStatuses List of {@link ReadyStatus} corresponding to the APIs
   * @return A {@link ReadyStatus} with the info of all APIs.
   */
  ReadyStatus readyStatus(List<ReadyStatus> readyStatuses);

  /**
   * @param apiId Id of the API that corresponds with the status.
   * @return a {@link ReadyStatus} with the message Indicating that the API is not deployed in the runtime.
   */
  ReadyStatus missingApi(Long apiId);
}
