/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;

import java.io.File;

import org.apache.commons.io.FilenameUtils;

public class OfflinePolicyDefinitionValidator {

  public static void validate(File definitionFile) {
    if (!definitionFile.exists()) {
      throw new OfflinePolicyDeserializationException("Policy definition file: " + definitionFile + " does not exist.");
    }

    if (!hasJsonExtension(definitionFile)) {
      throw new OfflinePolicyDeserializationException("Invalid extension in " + definitionFile);
    }
  }

  private static boolean hasJsonExtension(File definitionFile) {
    return FilenameUtils.getExtension(definitionFile.getName()).equals("json");
  }
}
