/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.getOfflinePoliciesFolder;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Lifecycle;

import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;

import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * In charge of managing the monitor of the offline policies directory
 */
public class OfflinePolicyWatcher implements Lifecycle {

  private static final Logger LOGGER = LoggerFactory.getLogger(OfflinePolicyWatcher.class);

  private static final long POLLING_INTERVAL = 100;

  private final FileAlterationListener listener;
  private final FileAlterationMonitor monitor;

  public OfflinePolicyWatcher(PolicyDeploymentService policyDeploymentService) {
    this.listener = new OfflinePolicyListener(policyDeploymentService);
    this.monitor = new FileAlterationMonitor(POLLING_INTERVAL);
  }

  @Override
  public void initialise() {
    FileAlterationObserver observer = new FileAlterationObserver(getOfflinePoliciesFolder());

    observer.addListener(listener);

    monitor.addObserver(observer);
    monitor.setThreadFactory(r -> {
      Thread t = new Thread(r);
      t.setName("agw-offline-policy-watcher");
      return t;
    });
  }

  @Override
  public void start() throws MuleException {
    try {
      LOGGER.debug("Policy monitor started at {}", getOfflinePoliciesFolder().getCanonicalPath());
      monitor.start();
    } catch (Exception e) {
      LOGGER.error("Error starting policies monitor. Reason: {}", e);
    }
  }

  @Override
  public void stop() throws MuleException {
    try {
      monitor.stop();
    } catch (Exception e) {
      LOGGER.error("Error stopping monitor.", e);
    }
  }

  @Override
  public void dispose() {}
}
