/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import org.mule.runtime.core.internal.util.OneTimeWarning;
import org.mule.runtime.http.policy.api.HttpPolicyPointcutParameters;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskedPathExtractor implements PolicyPointcutParametersPathExtractor {

  private static final Logger LOGGER = LoggerFactory.getLogger(EffectiveHttpResourcePointcut.class);

  private final OneTimeWarning oneTimeWarning = new OneTimeWarning(LOGGER,
                                                                   "HTTP Listener does not defines a * in its path. Full HTTP request path is used to check against policy resource matching since base path can not be identified.");

  @Override
  public String getPath(PolicyPointcutParameters parameters) {
    String path = ((HttpPolicyPointcutParameters) parameters).getPath();
    String maskedRequestPath = ((HttpPolicyPointcutParameters) parameters).getMaskedRequestPath();

    if (maskedRequestPath == null || path.equals(maskedRequestPath)) {
      oneTimeWarning.warn();
      return path;
    }

    return maskedRequestPath;
  }
}
