/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import static com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor.errorMessage;

import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.model.ValidPolicySpecification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

import java.io.File;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicySpecificationBuilder {

  private final Logger LOGGER = LoggerFactory.getLogger(PolicySpecificationBuilder.class);

  private File yamlFile;

  public PolicySpecificationBuilder withFile(File yamlFile) {
    this.yamlFile = yamlFile;
    return this;
  }

  public PolicySpecification build() {
    if (yamlFile != null && yamlFile.exists()) {
      ObjectMapper mapper = new ObjectMapper(new YAMLFactory());

      try {
        LOGGER.debug("Parsing yaml file {}", yamlFile.getName());
        return mapper.readValue(yamlFile, ValidPolicySpecification.class);
      } catch (IOException e) {
        LOGGER.warn("Parsing yaml file {} failed: {}", yamlFile.getName(), errorMessage(e));
      }
    }

    return new EmptyPolicySpecification();
  }
}
