/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

/**
 * Provides functionality to handle policies in a broader way than the policy engine.
 */
public interface PolicyDeploymentService {

  /**
   * Deploys a policy to the API implementations specified in the definition
   *
   * @param policy policy definition to handle
   */
  void newPolicy(PolicyDefinition policy);

  /**
   * First undeploys the policy, and then deploys it again. If the new deploy fails, the old policy will try to be restored.
   *
   * @param oldPolicy policy that is currently deployed
   * @param updatedPolicy policy with the changes that needs to be deployed
   */
  void updatePolicy(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy);

  /**
   * Indicates that the version currently applied has become the official configuration. This is the case of a configuration being
   * reverted once the edition failed.
   *
   * @param policy definition of the applied policy.
   */
  void revertPolicy(PolicyDefinition policy);

  /**
   * Changes Policy Order without reapplying the policy. This method will try to reorder the policy without undeploying the
   * policy; if the runtime does not support this feature, a normal update will be triggered.
   *
   * @param oldPolicy policy that is currently deployed
   * @param reorderedPolicy policy with the new order
   *
   */
  void reorderPolicy(PolicyDefinition oldPolicy, PolicyDefinition reorderedPolicy);

  /**
   * Removes the specified policy from the API implementation specified in the definition
   *
   * @param policyDefinition of the policy to remove
   */
  void removePolicy(PolicyDefinition policyDefinition);

  /**
   * Removes the specified policy
   *
   * @param policyName of the policy to remove
   */
  void removePolicy(String policyName);

}
