/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;

import java.util.List;
import java.util.Map;

/**
 * Provides functionality to update set of policies, all of them related to the same Api. Also, notifies the updates to all
 * {@link PolicySetDeploymentListener} that are listening.
 */
public interface PolicySetDeploymentService extends ApiDeploymentListener {

  /**
   * Add, updates or remove policies for the specified API.
   *
   * @param apiKey specified API
   * @param policySet set of policies
   */
  void policiesForApi(ApiKey apiKey, PolicySet policySet);

  /**
   * Removes every policy from the specified API
   *
   * @param apiKey specified API
   */
  void removeAll(ApiKey apiKey);

  /**
   * Adds a listener which will be notified of the events related to policy deployments
   *
   * @param listener the listener to add
   */
  void addPolicyDeploymentListener(PolicySetDeploymentListener listener);

  /**
   * Stores missing desired policies and deletes policies that are not desired. This is necessary when policies are replicated and
   * the API is not deployed in a node, but it is still wanted to reflect the policies state in that node
   *
   * @param apiKey api to conciliate
   * @param desiredPolicies list of desired policies
   */
  void conciliatePolicies(ApiKey apiKey, List<PolicyDefinition> desiredPolicies);

  /**
   * Returns the online policies present in the file system, grouped by API
   *
   * @return a map with an entry for every API that has policies stored
   */
  Map<ApiKey, List<PolicyDefinition>> storedOnlinePoliciesByApi();

}
