/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection.change;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

/**
 * Indicates that the policy suffered major changes and an update is in order. Additionally, the current status can be safely
 * recovered if the action fails.
 */
public class PolicyUpdate extends RecoverableChangeType {

  public PolicyUpdate(PolicyDefinition policyDefinition, PolicyDefinition newDefinition) {
    super(policyDefinition, newDefinition);
  }

  @Override
  public void accept(ChangeTypeVisitor visitor) {
    visitor.visit(this);
  }
}
