/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import static org.apache.commons.io.FileUtils.deleteQuietly;
import static org.apache.commons.io.FileUtils.write;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

/**
 * Defines the behavior of storing the encrypted-properties.yaml file used for encrypting configuration data for policies.
 *
 */
public class EncryptedPropertiesSerializer {

  static final String ENCRYPTED_PROPERTIES_YAML_FILE_NAME = "encrypted-properties.yaml";

  /**
   *
   * @param config policy parameters to generate the properties file with
   * @param destFolder where to store the file
   * @throws IOException If the file couldn't be stored
   */
  void store(Map<String, Object> config, File destFolder) throws IOException {
    DumperOptions options = new DumperOptions();
    options.setPrettyFlow(true);
    options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);

    Yaml yaml = new Yaml(options);

    if (!config.isEmpty()) {
      String output = yaml.dump(config);

      File file = new File(destFolder, ENCRYPTED_PROPERTIES_YAML_FILE_NAME);
      write(file, output, Charset.defaultCharset());
    } else {
      deleteQuietly(new File(destFolder, ENCRYPTED_PROPERTIES_YAML_FILE_NAME));
    }
  }

}
