/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.store;

import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.FAILED_POLICIES_FOLDER;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.HDP_API_REGISTRY_FOLDER;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.OFFLINE_POLICIES_FOLDER;
import static com.mulesoft.mule.runtime.gw.api.PolicyFolders.POLICY_TEMPLATES_FOLDER;
import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;

import java.io.File;
import java.util.List;

public class PolicyStoreFiles {

  private File policiesWorkingDir;

  public PolicyStoreFiles(File policiesWorkingDir) {
    this.policiesWorkingDir = policiesWorkingDir;
  }

  /**
   * Lists all the policy folders that are placed inside the policies directory ( %MULE_HOME%/policies ).
   *
   * @return array of policy folders
   */
  public List<File> listPolicyFolders() {
    return asList(policiesWorkingDir.listFiles(
                                               file -> file.isDirectory() &&
                                                   !file.getName().equals(FAILED_POLICIES_FOLDER) &&
                                                   !file.getName().equals(POLICY_TEMPLATES_FOLDER) &&
                                                   !file.getName().equals(OFFLINE_POLICIES_FOLDER) &&
                                                   !file.getName().equals(HDP_API_REGISTRY_FOLDER)));
  }

  /**
   * Lists all the offline policies descriptors that are placed inside the offline policies folder (
   * %MULE_HOME%/policies/offline-policies).
   *
   * @return array of policy folders
   */
  public List<File> listOfflinePoliciesDescriptors() {
    File offlinePoliciesFolder = new File(policiesWorkingDir, OFFLINE_POLICIES_FOLDER);
    return offlinePoliciesFolder.exists() ? asList(offlinePoliciesFolder.listFiles(file -> !file.isDirectory())) : emptyList();
  }


  public File getFailedPoliciesFolder() {
    return new File(policiesWorkingDir, FAILED_POLICIES_FOLDER);
  }

  /**
   * Lists all the policy folders that are placed inside the failed policies directory ( %MULE_HOME%/policies/failed-policies ).
   *
   * @return the failed policies folder
   */
  public List<File> listPolicyDeploymentFailures() {
    File failedPoliciesFolder = getFailedPoliciesFolder();
    return failedPoliciesFolder.exists() ? asList(getFailedPoliciesFolder().listFiles()) : emptyList();
  }

  /**
   * Returns the folder of a particular policy. It does not try to create it if it does not exist.
   *
   * @param policyName name of the policy
   * @return the specified policy folder
   */
  public File getPolicyFolder(String policyName) {
    return new File(policiesWorkingDir, policyName);
  }
}
