/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionBuilder;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;
import java.util.Map;

public abstract class PolicyFactoryTemplate
implements PolicyFactory {
    private PolicyTemplateResolver templateResolver;
    private PolicyTemplateProvider templateProvider;

    public PolicyFactoryTemplate(PolicyTemplateResolver templateResolver, PolicyTemplateProvider templateProvider) {
        this.templateResolver = templateResolver;
        this.templateProvider = templateProvider;
    }

    protected PolicyTemplate getPolicyTemplate(PolicyDefinition policyDefinition) {
        return this.templateProvider.provide(policyDefinition.getTemplateKey());
    }

    protected String resolveTemplate(PolicyTemplate policyTemplate, Map<String, Object> configurationData) {
        return this.templateResolver.resolve(policyTemplate, configurationData);
    }

    protected PolicyDefinition evaluatePolicyIdentityManagement(PolicyDefinition policyDefinition, PolicyTemplate policyTemplate) {
        if (this.shouldRemoveIdentityManagementProperty(policyDefinition, policyTemplate.getPolicySpecification())) {
            return this.getPolicyDefinitionWithoutIdentityManagement(policyDefinition);
        }
        return policyDefinition;
    }

    private boolean shouldRemoveIdentityManagementProperty(PolicyDefinition policyDefinition, PolicySpecification policySpecification) {
        return policySpecification.isValid() && !policySpecification.getIdentityManagement().isPresent() && PolicyDefinitionBuilder.hasIdentityManagementProperties(policyDefinition);
    }

    private PolicyDefinition getPolicyDefinitionWithoutIdentityManagement(PolicyDefinition policyDefinition) {
        return new PolicyDefinitionBuilder(policyDefinition).noIdentityManagement().build();
    }
}

