/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mulesoft.mule.runtime.gw.hdp.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.pointcut.ApiPointcutAdapter;
import com.mulesoft.mule.runtime.gw.policies.pointcut.CompositePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.EffectiveHttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.FullPathExtractor;
import com.mulesoft.mule.runtime.gw.policies.pointcut.HttpHeaderPointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.IsHttpComponentPointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.MaskedPathExtractor;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PolicyPointcutParametersPathExtractor;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyParametrizationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyParametrizationFactory.class);
    private static final String PARAMETER_ENCRYPTED_PROPERTIES_FILE = "encryptedPropertiesFile";
    private static final String API_ID = "apiId";
    private static final String IS_WSDL_ENDPOINT = "isWsdlEndpoint";
    private static final String IS_POLICY_REORDER = "isPolicyReorder";
    private static final String IS_WSDL_ENDPOINT_DEFAULT = "false";
    private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

    public PolicyParametrization create(PolicyDefinition policyDefinition, ApiImplementation implementation, File policyConfigFile, File encryptedPropertiesFile, Boolean isPolicyReorder, List<NotificationListener> notificationListeners) {
        Map<String, String> defaultParameters = this.createDefaultParameters(implementation, policyDefinition, encryptedPropertiesFile, isPolicyReorder);
        PolicyPointcut effectivePointcut = this.createEffectivePointcut(policyDefinition, implementation);
        String name = this.buildParametrizationId(policyDefinition.getName(), implementation);
        return new PolicyParametrization(name, effectivePointcut, policyDefinition.getOrder().intValue(), defaultParameters, policyConfigFile, notificationListeners);
    }

    public String buildParametrizationId(String policyName, ApiImplementation implementation) {
        return policyName + "-" + implementation.getFlow().getName();
    }

    private Map<String, String> createDefaultParameters(ApiImplementation implementation, PolicyDefinition policyDefinition, File encryptedPropertiesFile, boolean isPolicyReorder) {
        policyDefinition.getConfigurationData().getConfiguration().getOrDefault(IS_WSDL_ENDPOINT, IS_WSDL_ENDPOINT_DEFAULT);
        String wsdlConfiguration = policyDefinition.getConfigurationData().getConfiguration().getOrDefault(IS_WSDL_ENDPOINT, IS_WSDL_ENDPOINT_DEFAULT).toString();
        ImmutableMap.Builder builder = new ImmutableMap.Builder().putAll(this.getEncryptedProperties(encryptedPropertiesFile)).put((Object)API_ID, (Object)implementation.getApiKey().id().toString()).put((Object)IS_WSDL_ENDPOINT, (Object)wsdlConfiguration);
        if (isPolicyReorder) {
            builder.put((Object)IS_POLICY_REORDER, (Object)Boolean.TRUE.toString());
        }
        return builder.build();
    }

    private PolicyPointcut createEffectivePointcut(PolicyDefinition policyDefinition, ApiImplementation implementation) {
        String flowName = implementation.getFlow().getName();
        ApiPointcutAdapter apiPointcutAdapter = new ApiPointcutAdapter(policyDefinition.getName(), flowName);
        CompositePointcut pointcut = CompositePointcut.and(apiPointcutAdapter, new IsHttpComponentPointcut(policyDefinition.getName()));
        if (implementation.isHdp()) {
            pointcut = this.applyHdpPointcut(policyDefinition.getName(), pointcut, implementation);
        }
        if (policyDefinition.getHttpResourcePointcuts().isEmpty()) {
            LOGGER.debug("There are no resource pointcuts defined for policy {}. It will be applied to flow {}", (Object)policyDefinition.getName(), (Object)flowName);
            return pointcut;
        }
        PolicyPointcutParametersPathExtractor pathExtractor = implementation.isIgnoreBasePathOnResourceLevel() ? new MaskedPathExtractor() : new FullPathExtractor();
        List resourcePointcuts = policyDefinition.getHttpResourcePointcuts().stream().map(httpResourcePointcut -> new EffectiveHttpResourcePointcut(policyDefinition.getName(), httpResourcePointcut.getPath(), httpResourcePointcut.getMethod(), pathExtractor)).collect(Collectors.toList());
        return CompositePointcut.and((PolicyPointcut)pointcut, (PolicyPointcut)CompositePointcut.or(Lists.newArrayList(resourcePointcuts)));
    }

    private CompositePointcut applyHdpPointcut(String policyName, CompositePointcut pointcut, ApiImplementation implementation) {
        return implementation.getHdpService().map(service -> {
            HttpHeaderPointcut headerPointcut = new HttpHeaderPointcut(policyName, this.hdpConfiguration.getHdpServiceHeader(), (String)service);
            LOGGER.debug("Injecting header pointcut {} for service {}", (Object)headerPointcut.toString(), service);
            return CompositePointcut.and((PolicyPointcut)pointcut, (PolicyPointcut)headerPointcut);
        }).orElse(pointcut);
    }

    private Map<String, String> getEncryptedProperties(File encryptedProperties) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Optional.ofNullable(encryptedProperties).map(File::getAbsolutePath).ifPresent(absolutePath -> parameters.put(PARAMETER_ENCRYPTED_PROPERTIES_FILE, (String)absolutePath));
        return parameters;
    }
}

