/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.filter;

import static com.google.common.collect.ImmutableList.of;

import com.mulesoft.mule.runtime.gw.model.PolicyProperty;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

/**
 * Filters properties that belongs to an IdentityManagement configuration in Federation Policies. These properties should ALWAYS
 * be encrypted.
 *
 * This filter is used when the encryption feature is enabled.
 */
public class IdentityManagementFilter implements Predicate<String> {

  private static final String IDENTITY_MANAGEMENT_PREFIX = "identityManagement";
  private static final String IDENTITY_MANAGEMENT_TOKEN_URL = IDENTITY_MANAGEMENT_PREFIX + "TokenUrl";
  private static final String IDENTITY_MANAGEMENT_CLIENT_ID = IDENTITY_MANAGEMENT_PREFIX + "ClientId";
  private static final String IDENTITY_MANAGEMENT_CLIENT_SECRET = IDENTITY_MANAGEMENT_PREFIX + "ClientSecret";

  private static final List<String> IDENTIFY_MANAGEMENT_PROPERTIES =
      of(IDENTITY_MANAGEMENT_TOKEN_URL, IDENTITY_MANAGEMENT_CLIENT_ID, IDENTITY_MANAGEMENT_CLIENT_SECRET);

  @Override
  public boolean test(String key) {
    return IDENTIFY_MANAGEMENT_PROPERTIES.contains(key);
  }
}
