/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicySet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdpApisHealthCheckListener extends GateKeeper {

  private static final Logger LOGGER = LoggerFactory.getLogger(HdpApisHealthCheckListener.class);

  public HdpApisHealthCheckListener(ApiService apiService) {
    super(apiService);
  }

  @Override
  protected boolean validOrigin(PolicySet set) {
    return true;
  }

  @Override
  protected boolean isMonitored(Api api) {
    return api.getImplementation().isHdp();
  }

  @Override
  protected void blockApi(Api api) {
    api.getImplementation().gatekeeperStatus().blocked();
  }

  @Override
  protected void unblockApi(Api api) {
    LOGGER.info("Api policy set deployment on hdp complete, unblocking api: {}", api.getKey().toString());
    api.getImplementation().gatekeeperStatus().unblocked();
  }

}
