/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.template.exception;

import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED;

import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus;

/**
 * Exception thrown when an error occurs while downloading or unzipping a policy template or its metadata
 */
public class PolicyTemplateAssetException extends PolicyTemplateException {

  private static final long serialVersionUID = -7821861583624532283L;

  public PolicyTemplateAssetException(String message, Exception cause) {
    super(message, cause);
  }

  @Override
  public DeploymentStatus status() {
    return TEMPLATE_DOWNLOAD_FAILED;
  }
}
