/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.filter;

import static com.google.common.collect.ImmutableList.of;

import com.mulesoft.mule.runtime.gw.model.PolicyProperty;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

/**
 * Filters properties that match with a keyvalue type.
 *
 * This filter is used when the encryption feature is enabled.
 */
public class KeyvalueTypeFilter implements Predicate<PolicyProperty> {

  private static final List<String> VALID_MAPS = of("keyvalues");

  @Override
  public boolean test(PolicyProperty policyProperty) {
    return VALID_MAPS.contains(policyProperty.getType()) && !policyProperty.getAllowMultiple();
  }

}
