/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import org.mule.runtime.policy.api.PolicyPointcutParameters;

public interface PolicyPointcutParametersPathExtractor {

  /**
   * Extracts the path from a{@link PolicyPointcutParameters}, since they may expose different paths from an incoming HTTP
   * request, like the full path or the masked path, Depending on configuration, one or another should be used.
   * 
   * @param parameters parameters used to evaluate the pointcut created using the current request. Non null.
   * @return the extracted path from the parameters
   */
  String getPath(PolicyPointcutParameters parameters);
}
