/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.deployment.TransactionalPolicyDeployer;

import java.util.function.Consumer;

public class DefaultPolicyDeploymentService implements PolicyDeploymentService {

  private final ApiService apiService;
  private final TransactionalPolicyDeployer policyDeployer;
  private final PolicyDeploymentTracker policyDeploymentTracker;

  public DefaultPolicyDeploymentService(ApiService apiService,
                                        PolicyDeploymentTracker policyDeploymentTracker,
                                        TransactionalPolicyDeployer policyDeployer) {
    this.apiService = apiService;
    this.policyDeploymentTracker = policyDeploymentTracker;
    this.policyDeployer = policyDeployer;
  }

  @Override
  public void newPolicy(PolicyDefinition policy) {
    forAllApis(policy, api -> policyDeployer.deploy(policy, api));
  }

  @Override
  public void updatePolicy(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy) {
    forAllApis(updatedPolicy, api -> policyDeployer.update(oldPolicy, updatedPolicy, api));
  }

  @Override
  public void revertPolicy(PolicyDefinition policy) {
    forAllApis(policy, api -> policyDeployer.revertPolicy(policy, api));
  }

  @Override
  public void reorderPolicy(PolicyDefinition oldPolicy, PolicyDefinition reorderedPolicy) {
    forAllApis(reorderedPolicy, api -> policyDeployer.updateOrder(oldPolicy, reorderedPolicy, api));
  }

  @Override
  public void removePolicy(PolicyDefinition policy) {
    forAllApis(policy, api -> policyDeployer.undeploy(policy.getName(), api));
  }

  @Override
  public void removePolicy(String policyName) {
    policyDeploymentTracker.findByName(policyName).ifPresent(this::removePolicy);
  }

  private void forAllApis(PolicyDefinition policyDefinition, Consumer<Api> consumer) {
    policyDefinition.getApiKeys().forEach(key -> {
      apiService.get(key).ifPresent(consumer);
    });
  }

}
