/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.template;

import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.ValidPolicySpecification;

import java.io.File;

public class PolicyTemplate {

  /**
   * Key of the template
   */
  private final PolicyTemplateKey key;

  /**
   * File containing the policy template
   */
  private final File templateFile;

  /**
   * Template descriptor
   */
  private final PolicyTemplateDescriptor templateDescriptor;

  /**
   * Modeled Yaml in template asset when parsed
   */
  private final PolicySpecification policySpecification;

  public PolicyTemplate(PolicyTemplateKey key, File templateFile, PolicySpecification policySpecification,
                        PolicyTemplateDescriptor templateDescriptor) {
    this.key = key;
    this.templateFile = templateFile;
    this.templateDescriptor = templateDescriptor;
    this.policySpecification = policySpecification;
  }

  public PolicyTemplateKey getKey() {
    return key;
  }

  public File getTemplateFile() {
    return templateFile;
  }

  public PolicyTemplateDescriptor getTemplateDescriptor() {
    return templateDescriptor;
  }

  public PolicySpecification getPolicySpecification() {
    return policySpecification;
  }
}
