/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import static com.google.common.base.Preconditions.checkState;
import static org.apache.commons.io.FileUtils.copyInputStreamToFile;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;

/**
 * Looks for a policy template JAR in the classpath
 */
public class ClasspathPolicyTemplateProvider extends PolicyTemplateProvider {

  public static final String POLICY_TEMPLATE_FILE_NAME_PATTERN = "/%s-mule-policy.jar";

  @Override
  protected PolicyTemplateAssets getPolicyTemplateAssets(PolicyTemplateKey templateKey) throws IOException {
    File templateJarFile = getFileAsResource(templateKey,
                                             String.format(POLICY_TEMPLATE_FILE_NAME_PATTERN, templateKey.getAssetId()));

    return new PolicyTemplateAssets(templateJarFile);
  }

  private File getFileAsResource(PolicyTemplateKey templateKey, String resource) throws IOException {

    InputStream resourceStream = getClass().getResourceAsStream(resource);

    checkState(resourceStream != null,
               String.format("Could not find policy template asset %s for %s", resource, templateKey.getAssetId()));

    File targetFile = new File(templatesTempFolder, resource);

    copyInputStreamToFile(resourceStream, targetFile);

    return targetFile;
  }

}
