/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.template.resolver;

import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;

import java.util.Map;

/**
 * Defines a generic way for resolving policy templates
 */
public interface PolicyTemplateResolver {

  /**
   * Resolves the template for a policy
   * 
   * @param policyTemplate The policy to resolve
   * @param configurationData The required data to fill in the template
   * @return The template with its resolved values
   */
  String resolve(PolicyTemplate policyTemplate, Map<String, Object> configurationData) throws PolicyTemplateResolverException;

}
