/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_FAILED;
import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.DEPLOYMENT_SUCCESS;
import static com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus.TEMPLATE_DOWNLOAD_FAILED;
import static java.util.Optional.empty;
import static java.util.Optional.of;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus.DeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;

public class DeploymentStatusTestFactory {

  public static PolicyDefinitionDeploymentStatus appliedDefinition(PolicyDefinition definition) {
    return policyDefinition(definition, DEPLOYMENT_SUCCESS);
  }

  public static PolicyDefinitionDeploymentStatus deploymentFailedDefinition(PolicyDefinition definition) {
    return policyDefinition(definition, DEPLOYMENT_FAILED);
  }

  public static PolicyDeploymentStatus applied(PolicyDefinition definition) {
    return new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(definition));
  }

  public static PolicyDeploymentStatus downloadFailed(PolicyDefinition def) {
    return policyFailed(def, TEMPLATE_DOWNLOAD_FAILED);
  }

  public static PolicyDeploymentStatus deploymentFailed(PolicyDefinition def) {
    return policyFailed(def, DEPLOYMENT_FAILED);
  }

  public static PolicyDeploymentStatus deploymentFailed(PolicyDefinition successful, PolicyDefinition failed) {
    return failedWithAppliedRevert(successful, failed, DEPLOYMENT_FAILED);
  }

  public static PolicyDeploymentStatus downloadFailed(PolicyDefinition successful, PolicyDefinition failed) {
    return failedWithAppliedRevert(successful, failed, TEMPLATE_DOWNLOAD_FAILED);
  }

  public static PolicyDeploymentStatus policyApplied(PolicyDefinition definition, DeploymentStatus status) {
    if (status.equals(DEPLOYMENT_SUCCESS)) {
      return applied(definition);
    } else {
      return policyFailed(definition, status);
    }
  }

  private static PolicyDeploymentStatus policyFailed(PolicyDefinition definition,
                                                     DeploymentStatus status) {
    return new PolicyDeploymentStatus(
                                      policyDefinition(definition, status),
                                      empty());
  }

  private static PolicyDeploymentStatus failedWithAppliedRevert(PolicyDefinition successful, PolicyDefinition failed,
                                                                DeploymentStatus cause) {
    return new PolicyDeploymentStatus(
                                      policyDefinition(failed, cause),
                                      of(appliedDefinition(successful)));
  }

  private static PolicyDefinitionDeploymentStatus policyDefinition(PolicyDefinition definition,
                                                                   DeploymentStatus status) {
    return new PolicyDefinitionDeploymentStatus(definition, status, null);
  }
}
