/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.anypoint.tests.logger.DebugLine;
import com.mulesoft.anypoint.tests.logger.InfoLine;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.DefaultTransactionalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.TransactionalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.notification.PolicyNotificationListenerSuppliers;
import com.mulesoft.mule.runtime.gw.policies.service.DefaultPolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.exception.PolicyTemplateResolverException;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationPolicyManager;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.policy.PolicyRegistrationException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.policy.api.PolicyPointcut;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultPolicyDeployerTestCase
extends AbstractMuleTestCase {
    private static final String FLOW_NAME = "flowName";
    private static final String RESOLVED_TEMPLATE = "resolvedTemplate";
    @Rule
    public SystemPropertyTemporaryFolder temporaryFolder = new SystemPropertyTemporaryFolder("mule.home");
    @Mock
    private Api api;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Application application;
    @Mock
    private ApplicationPolicyManager policyManager;
    @Mock
    private PolicyParametrizationFactory policyParametrizationFactory;
    @Mock
    private PolicyStore policyStore;
    private PolicyTemplateDescriptor templateDescriptor;
    private PolicyParametrization policyParametrization;
    private Policy policy;
    private PolicyDefinition policyDefinition;
    private DefaultPolicyDeploymentTracker policyDeploymentTracker;
    private PolicyDeploymentListener policyDeploymentListener;
    private ApiImplementation apiImplementation;
    private TransactionalPolicyDeployer transactionalPolicyDeployer;
    private MockLogger logger;
    private PolicyFactory policyFactory;

    @Before
    public void setUp() throws PolicyTemplateResolverException {
        PolicyTemplate template = (PolicyTemplate)Mockito.mock(PolicyTemplate.class);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        this.logger = new MockLogger();
        this.policyDefinition = new PolicyDefinition("policyId", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY, PolicyTestValuesConstants.API_KEY, Collections.emptyList(), 1, new PolicyConfiguration(Collections.emptyMap()));
        this.policyFactory = (PolicyFactory)Mockito.mock(PolicyFactory.class);
        this.policy = new Policy(template, this.policyDefinition, RESOLVED_TEMPLATE);
        Mockito.when((Object)this.policyFactory.createFromPolicyDefinition(this.policyDefinition)).thenReturn((Object)this.policy);
        this.apiImplementation = new ApiImplementation(PolicyTestValuesConstants.API_KEY, this.application, flow, false);
        this.policyDeploymentTracker = new DefaultPolicyDeploymentTracker();
        this.policyDeploymentListener = (PolicyDeploymentListener)Mockito.mock(PolicyDeploymentListener.class);
        this.policyDeploymentTracker.addPolicyDeploymentListener(this.policyDeploymentListener);
        DefaultPolicyDeployer defaultPolicyDeployer = new DefaultPolicyDeployer(this.policyStore, this.policyFactory, new PolicyNotificationListenerSuppliers());
        this.transactionalPolicyDeployer = new DefaultTransactionalPolicyDeployer((PolicyDeploymentTracker)this.policyDeploymentTracker, this.policyStore, (PolicyDeployer)defaultPolicyDeployer);
        this.policyParametrization = new PolicyParametrization("id", (PolicyPointcut)Mockito.mock(PolicyPointcut.class), 1, Collections.emptyMap(), (File)Mockito.mock(File.class), Collections.emptyList());
        this.templateDescriptor = new PolicyTemplateDescriptor("name");
        Mockito.when((Object)this.api.getImplementation()).thenReturn((Object)this.apiImplementation);
        Mockito.when((Object)this.api.getKey()).thenReturn((Object)PolicyTestValuesConstants.API_KEY);
        Mockito.when((Object)flow.getName()).thenReturn((Object)FLOW_NAME);
        Mockito.when((Object)this.application.getStatus()).thenReturn((Object)ApplicationStatus.STARTED);
        Mockito.when((Object)this.application.getPolicyManager()).thenReturn((Object)this.policyManager);
        Mockito.when((Object)this.policyParametrizationFactory.create((PolicyDefinition)Matchers.any(), (ApiImplementation)Matchers.any(), (File)Matchers.any(), (File)Matchers.any(), (Boolean)Matchers.any(), (List)Matchers.any())).thenReturn((Object)this.policyParametrization);
        Mockito.when((Object)template.getTemplateDescriptor()).thenReturn((Object)this.templateDescriptor);
        Mockito.when((Object)template.getPolicySpecification()).thenReturn((Object)new EmptyPolicySpecification());
        Mockito.when((Object)this.application.getArtifactClassLoader().getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        VariableOverride.overrideVariable((String)"policyDeployer.policyParametrizationFactory").in((Object)this.transactionalPolicyDeployer).with((Object)this.policyParametrizationFactory);
        VariableOverride.overrideLogger().in((Object)defaultPolicyDeployer).with((Object)this.logger);
        VariableOverride.overrideLogger().in((Object)this.transactionalPolicyDeployer).with((Object)this.logger);
    }

    @Test
    public void deployPolicy() throws PolicyRegistrationException {
        this.transactionalPolicyDeployer.deploy(this.policyDefinition, this.api);
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentSuccess(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Is.is((Object)false));
        ((ApplicationPolicyManager)Mockito.verify((Object)this.policyManager)).addPolicy(this.templateDescriptor, this.policyParametrization);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).store(this.policy);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).cleanDeploymentFailure(this.policyDefinition, PolicyTestValuesConstants.API_KEY);
        Assert.assertThat((String)"Log lines size does not match", (Object)this.logger.lines(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Is.is((Object)new DebugLine("Applying policy {} version {} to {} in application {}", new Object[]{this.policyDefinition.getName(), this.policyDefinition.getTemplateKey().getVersion(), this.api, this.api.getImplementation().getArtifactName()})));
        Assert.assertThat(this.logger.lines().get(1), (Matcher)Is.is((Object)new InfoLine("Applied policy {} version {} to {} in application {}", new Object[]{this.policyDefinition.getName(), this.policyDefinition.getTemplateKey().getVersion(), this.api, this.api.getImplementation().getArtifactName()})));
        ((PolicyDeploymentListener)Mockito.verify((Object)this.policyDeploymentListener)).policyDeployed(PolicyTestValuesConstants.API_KEY, this.successfulStatus(this.policyDefinition));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    @Test
    public void deployPolicyFails() throws PolicyRegistrationException {
        PolicyRegistrationException exception = new PolicyRegistrationException(null, null);
        ((ApplicationPolicyManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.policyManager)).addPolicy((PolicyTemplateDescriptor)Matchers.any(), (PolicyParametrization)Matchers.any());
        this.transactionalPolicyDeployer.deploy(this.policyDefinition, this.api);
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isDeploymentSuccess(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)((PolicyDeploymentStatus)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY).get(0)).getLatestPolicyStatus().isTemplateDownloadFailed(), (Matcher)Is.is((Object)false));
        ((ApplicationPolicyManager)Mockito.verify((Object)this.policyManager)).addPolicy(this.templateDescriptor, this.policyParametrization);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).store(this.policy);
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).storeDeploymentFailure(this.policyDefinition, this.apiImplementation.getApiKey(), (Exception)exception);
    }

    @Test
    public void undeployPolicy() {
        PolicyDeploymentStatus status = this.successfulStatus(this.policyDefinition);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, status);
        Mockito.reset((Object[])new PolicyDeploymentListener[]{this.policyDeploymentListener});
        Mockito.when((Object)this.policyManager.removePolicy((String)Matchers.any())).thenReturn((Object)true);
        boolean undeployed = this.transactionalPolicyDeployer.undeploy(this.policyDefinition.getName(), this.api);
        Assert.assertThat((Object)undeployed, (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)org.hamcrest.Matchers.empty());
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).remove(this.policyDefinition.getName());
        ((PolicyDeploymentListener)Mockito.verify((Object)this.policyDeploymentListener)).policyRemoved(PolicyTestValuesConstants.API_KEY, status);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    @Test
    public void undeployPolicyWithMultipleDeployments() {
        PolicyDeploymentStatus status = this.successfulStatus(this.policyDefinition);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY, status);
        this.policyDeploymentTracker.policyDeployed(PolicyTestValuesConstants.API_KEY_2, status);
        Mockito.reset((Object[])new PolicyDeploymentListener[]{this.policyDeploymentListener});
        Mockito.when((Object)this.policyManager.removePolicy((String)Matchers.any())).thenReturn((Object)true);
        boolean undeployed = this.transactionalPolicyDeployer.undeploy(this.policyDefinition.getName(), this.api);
        Assert.assertThat((Object)undeployed, (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY), (Matcher)org.hamcrest.Matchers.empty());
        Assert.assertThat((Object)this.policyDeploymentTracker.onlinePolicyStatuses(PolicyTestValuesConstants.API_KEY_2), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.policyStore});
        ((PolicyDeploymentListener)Mockito.verify((Object)this.policyDeploymentListener)).policyRemoved(PolicyTestValuesConstants.API_KEY, status);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    @Test
    public void undeployNotDeployedPolicy() {
        Mockito.when((Object)this.policyManager.removePolicy(this.policyDefinition.getName())).thenReturn((Object)false);
        boolean undeployed = this.transactionalPolicyDeployer.undeploy(this.policyDefinition.getName(), this.api);
        Assert.assertThat((Object)undeployed, (Matcher)Is.is((Object)false));
        ((PolicyStore)Mockito.verify((Object)this.policyStore)).remove(this.policyDefinition.getName());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentListener});
    }

    private PolicyDeploymentStatus successfulStatus(PolicyDefinition definition) {
        return new PolicyDeploymentStatus(new PolicyDefinitionDeploymentStatus(definition));
    }
}

