/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.mulesoft.anypoint.tests.logger.LogLine;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.TraceLine;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.IsHttpComponentPointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class IsHttpComponentPointcutTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_NAME = "name";
    private static final ComponentIdentifier INVALID_COMPONENT_IDENTIFIER = ComponentIdentifier.builder().namespace("invalid").name("component").build();
    private MockLogger logger;

    @Before
    public void setUp() {
        this.logger = new MockLogger();
    }

    @Test
    public void httpListenerComponentIsValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request matches pointcut of policy {} since {} is a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void httpRequesterComponentIsValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.requesterPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request matches pointcut of policy {} since {} is a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void annotatedHttpListenerComponentIsValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.annotatedListenerPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Annotation 'api-gateway:disablePolicies' has no effect on component {}", new Object[]{HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER})));
        Assert.assertThat(this.logger.lines().get(1), (Matcher)Matchers.is((Object)new TraceLine("Request matches pointcut of policy {} since {} is a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_LISTENER_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void annotatedHttpRequesterComponentIsNotValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        VariableOverride.overrideVariable((String)"notApplicableWarn.logger").in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.annotatedRequesterPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertTrue((boolean)((LogLine)this.logger.lines().get(0)).toString().contains("is annotated with 'api-gateway:disablePolicies', no operation block policies will be applied to this element"));
        Assert.assertTrue((boolean)((LogLine)this.logger.lines().get(1)).toString().contains("does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'"));
        Assert.assertThat(this.logger.lines().get(2), (Matcher)Matchers.is((Object)new TraceLine("Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void multipleCallToAnnotatedHttpRequesterWarnsOnce() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        VariableOverride.overrideVariable((String)"notApplicableWarn.logger").in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.annotatedRequesterPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertTrue((boolean)((LogLine)this.logger.lines().get(0)).toString().contains("is annotated with 'api-gateway:disablePolicies', no operation block policies will be applied to this element"));
        Assert.assertTrue((boolean)((LogLine)this.logger.lines().get(1)).toString().contains("does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'"));
        Assert.assertThat(this.logger.lines().get(2), (Matcher)Matchers.is((Object)new TraceLine("Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
        this.logger.lines().clear();
        matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertTrue((boolean)((LogLine)this.logger.lines().get(0)).toString().contains("does not apply for pointcut for being annotated with 'api-gateway:disablePolicies'"));
        Assert.assertThat(this.logger.lines().get(1), (Matcher)Matchers.is((Object)new TraceLine("Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, HttpResourcePointcut.HTTP_REQUEST_COMPONENT_IDENTIFIER})));
    }

    @Test
    public void anotherComponentIsNotValid() {
        IsHttpComponentPointcut pointcut = new IsHttpComponentPointcut(POLICY_NAME);
        VariableOverride.overrideLogger().in((Object)pointcut).with((Object)this.logger);
        PolicyPointcutParameters parameters = PointcutTestUtils.nonHttpPointcutParameters("");
        boolean matches = pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Request does not match pointcut of policy {} since {} is not a valid HTTP component.", new Object[]{POLICY_NAME, INVALID_COMPONENT_IDENTIFIER})));
    }
}

