/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;

import java.util.Collection;

/**
 * Provides the functionality to deploy and undeploy policies to applications
 */
public interface TransactionalPolicyDeployer extends PolicyDeployer {

  /**
   * Tries to update the order of the policy. If the order update fails a regular update will be triggered
   *
   * @param oldPolicy the policyDefinition before the order change
   * @param updatedPolicy the policyDefinition after the order change
   * @param api the api to which the policy will be deployed
   */
  void updateOrder(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api);

  /**
   * Tries to update the configuration of the policy. If the update fails the previous status of the policy will be recovered.
   *
   * @param oldPolicy the policyDefinition before the configuration change
   * @param updatedPolicy the policyDefinition after the configuration change
   * @param api the api to which the policy will be deployed
   */
  void update(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api);

  /**
   * Indicates that the version currently applied has become the official configuration. This is the case of a configuration being
   * reverted once the edition failed.
   *
   * @param policy definition of the applied policy.
   * @param api the api to which the policy will be deployed
   */
  void revertPolicy(PolicyDefinition policy, Api api);
}
