/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import static java.util.Optional.ofNullable;

import java.util.Optional;

/**
 * Represents the result of a single value encrypted
 *
 * Each result contains: The template placeholder that will be used in the XML; it can be the original value when there is no
 * encryption feature available, or the key surrounded by a prefix/suffix indicating that the value should be encrypted.
 *
 * The result of the encryption, if there is one, or the original value otherwise
 */
public class EncryptedValueResult<EncryptedType> {

  private final String key;
  private final EncryptedType templateValue;
  private final EncryptedType configurationValue;
  private final EncryptedType configFileValue;

  public EncryptedValueResult(String key, EncryptedType templateValue, EncryptedType configurationValue) {
    this(key, templateValue, configurationValue, null);
  }

  public EncryptedValueResult(String key, EncryptedType templateValue, EncryptedType configurationValue,
                              EncryptedType configFileValue) {
    this.key = key;
    this.templateValue = templateValue;
    this.configurationValue = configurationValue;
    this.configFileValue = configFileValue;
  }

  public EncryptedType getTemplateValue() {
    return templateValue;
  }

  public EncryptedType getConfigurationValue() {
    return configurationValue;
  }

  public String getKey() {
    return key;
  }

  public Optional<EncryptedType> getConfigFileValue() {
    return ofNullable(configFileValue);
  }

}
