/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import static java.lang.String.join;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.IdentityManagementFilter;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.StringTypeFilter;

import java.util.List;
import java.util.Optional;

/**
 * Knows how to encrypt and decrypt single config values that are represented with a {@link String}
 */
public class StringEncrypter extends PolicyTypeEncrypter<String> {

  public StringEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled,
                         List<PolicyProperty> policyProperties) {
    super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
  }

  @Override
  protected EncryptedValueResult encryptSingle(String key, String value) {
    String templateValue = join("", TEMPLATE_PREFIX, key, TEMPLATE_SUFFIX);

    String encrypted = encrypt(value);

    return new EncryptedValueResult<>(key, templateValue, encrypted, encrypted);
  }

  @Override
  protected EncryptedValueResult decryptSingle(String key, String value) {
    String decrypted = decrypt(value);

    return new EncryptedValueResult<>(key, decrypted, decrypted);
  }

  @Override
  protected boolean supports(String key, Optional<PolicyProperty> property) {
    return (property.isPresent() && new StringTypeFilter().test(property.get())) || new IdentityManagementFilter().test(key);
  }

}
