/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedPolicyException;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.resolver.PolicyTemplateResolver;

/**
 * Factory for {@link Policy}
 */
public class DefaultPolicyFactory extends PolicyFactoryTemplate {

  public DefaultPolicyFactory(PolicyTemplateResolver templateResolver,
                              PolicyTemplateProvider templateProvider) {
    super(templateResolver, templateProvider);
  }

  @Override
  public Policy createFromPolicyDefinition(PolicyDefinition policyDefinition) {
    if (policyDefinition.getConfigurationData().isEncrypted()) {
      throw new EncryptedPolicyException();
    }

    PolicyTemplate policyTemplate = getPolicyTemplate(policyDefinition);

    policyDefinition = evaluatePolicyIdentityManagement(policyDefinition, policyTemplate);

    String resolvedTemplate =
        resolveTemplate(policyTemplate, policyDefinition.getConfigurationData().getConfiguration());

    return new Policy(policyTemplate, policyDefinition, resolvedTemplate);
  }

}
