/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection;

import static com.google.common.collect.Lists.newArrayList;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.API_KEY;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_ID;
import static com.mulesoft.anypoint.tests.PolicyTestValuesConstants.POLICY_TEMPLATE_KEY;
import static com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory.applied;
import static com.mulesoft.mule.runtime.gw.policies.service.DeploymentStatusTestFactory.deploymentFailed;
import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;
import static java.util.Collections.singletonList;
import static java.util.Collections.singletonMap;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.mule.tck.junit4.AbstractMuleTestCase;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;

import org.junit.Before;
import org.junit.Test;

public class PolicyChangeProcessorTestCase extends AbstractMuleTestCase {

  private static final PolicyDefinition definition =
      new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, emptyMap());

  private static final PolicyDefinition updatedDefinition =
      new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 1, singletonMap("foo", "bar"));

  private PolicyDeploymentService deploymentService;
  private PolicyChangeProcessor changeProcessor;

  @Before
  public void setUp() {
    deploymentService = mock(PolicyDeploymentService.class);
    changeProcessor = new PolicyChangeProcessor(deploymentService);
  }

  @Test
  public void newPolicy() {
    changeProcessor.process(emptyList(), singletonList(definition));

    verify(deploymentService).newPolicy(definition);
  }

  @Test
  public void reorder() {
    PolicyDefinition reordered = new PolicyDefinition(POLICY_ID, POLICY_TEMPLATE_KEY, API_KEY, newArrayList(), 2, emptyMap());

    changeProcessor.process(singletonList(applied(definition)), singletonList(reordered));

    verify(deploymentService).reorderPolicy(definition, reordered);
  }

  @Test
  public void update() {
    changeProcessor.process(singletonList(applied(definition)), singletonList(updatedDefinition));

    verify(deploymentService).updatePolicy(definition, updatedDefinition);
  }

  @Test
  public void revertPolicy() {
    changeProcessor.process(singletonList(deploymentFailed(definition, updatedDefinition)), singletonList(definition));

    verify(deploymentService).revertPolicy(definition);
  }

  @Test
  public void removePolicy() {
    changeProcessor.process(singletonList(applied(definition)), emptyList());

    verify(deploymentService).removePolicy(definition);
  }

}
