/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template;

import com.mulesoft.anypoint.tests.PolicyTestValuesConstants;
import com.mulesoft.mule.runtime.gw.api.PolicyFolders;
import com.mulesoft.mule.runtime.gw.model.EmptyPolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import com.mulesoft.mule.runtime.gw.policies.template.provider.ClasspathPolicyTemplateProvider;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateDescriptorFactory;
import org.mule.tck.ZipUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;

public class ClasspathPolicyTemplateProviderTestCase
extends AbstractMuleTestCase {
    @Rule
    public TemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    private PolicyTemplateDescriptor templateDescriptor;
    private PolicyTemplateProvider templateProvider;

    @Before
    public void setUp() throws IllegalAccessException {
        this.templateProvider = new ClasspathPolicyTemplateProvider();
        PolicyTemplateDescriptorFactory templateDescriptorFactory = (PolicyTemplateDescriptorFactory)Mockito.mock(PolicyTemplateDescriptorFactory.class);
        this.templateDescriptor = new PolicyTemplateDescriptor("name");
        this.templateDescriptor.setRootFolder(PolicyFolders.getPolicyTemplatesTempFolder());
        Mockito.when((Object)templateDescriptorFactory.create((File)org.mockito.Matchers.any(), (Optional)org.mockito.Matchers.any())).thenReturn((Object)this.templateDescriptor);
        FieldUtils.writeField((Object)this.templateProvider, (String)"templateDescriptorFactory", (Object)templateDescriptorFactory, (boolean)true);
    }

    @Test
    public void provideTemplateFromClasspath() throws Exception {
        File zipWithTemplateInside = this.createZipWithTemplateInside(String.format("/%s-mule-policy.jar", PolicyTestValuesConstants.POLICY_TEMPLATE_KEY.getAssetId()));
        this.addZipToClasspath(zipWithTemplateInside);
        PolicyTemplate policyTemplate = this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY);
        Assert.assertThat((Object)policyTemplate.getKey(), (Matcher)Is.is((Object)PolicyTestValuesConstants.POLICY_TEMPLATE_KEY));
        Assert.assertThat((Object)policyTemplate.getTemplateFile(), (Matcher)Is.is((Object)new File(PolicyFolders.getPolicyTemplatesTempFolder(), policyTemplate.getKey().getName() + "/template.xml")));
        Assert.assertThat((Object)policyTemplate.getTemplateDescriptor(), (Matcher)Is.is((Object)this.templateDescriptor));
        Assert.assertThat((Object)policyTemplate.getPolicySpecification(), (Matcher)Is.is((Matcher)Matchers.instanceOf(EmptyPolicySpecification.class)));
        Assert.assertThat((Object)PolicyFolders.getPolicyTemplatesTempFolder().listFiles(), (Matcher)Matchers.arrayWithSize((int)2));
    }

    @Test(expected=IllegalStateException.class)
    public void templateNotPresentInClasspath() {
        this.templateProvider.provide(PolicyTestValuesConstants.POLICY_TEMPLATE_KEY_2);
    }

    private void addZipToClasspath(File zipFile) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, new URL("file:" + zipFile.getAbsolutePath()));
    }

    private File createZipWithTemplateInside(String templateFileName) throws Exception {
        File zipFile = new File(this.muleHome.getRoot(), "zip-with-template-jar-inside.zip");
        File jarFile = new File(this.muleHome.getRoot(), templateFileName);
        File jarFileContent = new File(this.muleHome.getRoot(), "template.xml");
        jarFileContent.createNewFile();
        ZipUtils.compress((File)jarFile, (ZipUtils.ZipResource[])new ZipUtils.ZipResource[]{new ZipUtils.ZipResource(jarFileContent.getAbsolutePath(), jarFileContent.getName())});
        ZipUtils.compress((File)zipFile, (ZipUtils.ZipResource[])new ZipUtils.ZipResource[]{new ZipUtils.ZipResource(jarFile.getAbsolutePath(), jarFile.getName())});
        return zipFile;
    }
}

