/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.TransactionalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyStore;
import java.util.Optional;
import org.slf4j.Logger;

public class DefaultTransactionalPolicyDeployer
implements TransactionalPolicyDeployer {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(DefaultTransactionalPolicyDeployer.class);
    private final PolicyDeploymentTracker policyDeploymentTracker;
    private final PolicyStore policyStore;
    private final PolicyDeployer policyDeployer;

    public DefaultTransactionalPolicyDeployer(PolicyDeploymentTracker policyDeploymentTracker, PolicyStore policyStore, PolicyDeployer policyDeployer) {
        this.policyDeployer = policyDeployer;
        this.policyDeploymentTracker = policyDeploymentTracker;
        this.policyStore = policyStore;
    }

    @Override
    public PolicyDefinitionDeploymentStatus deploy(PolicyDefinition policyDefinition, Api api) {
        PolicyDefinitionDeploymentStatus status = this.policyDeployer.deploy(policyDefinition, api);
        if (status.isDeploymentSuccess()) {
            this.informSuccessfullyDeploy(status, api);
        } else {
            this.informDeploymentFailure(new PolicyDeploymentStatus(status, Optional.empty()), api);
        }
        return status;
    }

    @Override
    public PolicyDefinitionDeploymentStatus updateOrder(PolicyDefinition policy, Api api) {
        return this.policyDeployer.updateOrder(policy, api);
    }

    @Override
    public void updateOrder(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api) {
        PolicyDefinitionDeploymentStatus status = this.updateOrder(updatedPolicy, api);
        if (status.isDeploymentSuccess()) {
            this.informSuccessfullyDeploy(status, api);
        } else {
            LOGGER.info("Hot Reorder Failed for policy {} in app {}, unapplying and reapplying policy to change the order.", (Object)updatedPolicy.getName(), (Object)api.getImplementation().getArtifactName());
            this.update(oldPolicy, updatedPolicy, api);
        }
    }

    @Override
    public void update(PolicyDefinition oldPolicy, PolicyDefinition updatedPolicy, Api api) {
        this.undeploy(oldPolicy.getName(), api);
        PolicyDefinitionDeploymentStatus status = this.policyDeployer.deploy(updatedPolicy, api);
        if (status.isDeploymentSuccess()) {
            this.informSuccessfullyDeploy(status, api);
        } else {
            this.undeploy(updatedPolicy.getName(), api);
            PolicyDefinitionDeploymentStatus revertStatus = this.policyDeployer.deploy(oldPolicy, api);
            if (revertStatus.isDeploymentSuccess()) {
                LOGGER.info("Successfully reverted {} in app {} to previous configuration.", (Object)oldPolicy.getName(), (Object)api.getImplementation().getArtifactName());
                this.informDeploymentFailure(new PolicyDeploymentStatus(status, Optional.of(revertStatus)), api);
            } else {
                LOGGER.error("Failed to revert {} in app {} to previous configuration, api will remain unprotected.", (Object)oldPolicy.getName(), (Object)api.getImplementation().getArtifactName());
                this.informDeploymentFailure(new PolicyDeploymentStatus(status, Optional.empty()), api);
            }
        }
    }

    @Override
    public void revertPolicy(PolicyDefinition policy, Api api) {
        this.informSuccessfullyDeploy(new PolicyDefinitionDeploymentStatus(policy), api);
    }

    @Override
    public boolean undeploy(String policyName, Api api) {
        boolean result = this.policyDeployer.undeploy(policyName, api);
        this.policyDeploymentTracker.policyRemoved(api.getKey(), policyName);
        if (!this.policyDeploymentTracker.hasDeployments(policyName)) {
            this.policyStore.remove(policyName);
        }
        return result;
    }

    private void informSuccessfullyDeploy(PolicyDefinitionDeploymentStatus status, Api api) {
        this.policyDeploymentTracker.policyRemoved(api.getImplementation().getApiKey(), status.getPolicyDefinition().getName());
        this.policyDeploymentTracker.policyDeployed(api.getImplementation().getApiKey(), new PolicyDeploymentStatus(status));
        this.policyStore.cleanDeploymentFailure(status.getPolicyDefinition(), api.getKey());
    }

    private void informDeploymentFailure(PolicyDeploymentStatus status, Api api) {
        this.policyDeploymentTracker.policyRemoved(api.getImplementation().getApiKey(), status.getLatestPolicyStatus().getPolicyDefinition().getName());
        this.policyDeploymentTracker.policyDeployed(api.getImplementation().getApiKey(), status);
        this.policyStore.store(status.getAppliedPolicyStatus().orElseGet(status::getLatestPolicyStatus).getPolicyDefinition());
        this.policyStore.storeDeploymentFailure(status.getLatestPolicyStatus().getPolicyDefinition(), api.getKey(), status.getLatestPolicyStatus().getException());
    }
}

