/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import static com.mulesoft.mule.runtime.gw.model.PolicyConfiguration.PROPERTY_ENCRYPTED;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypters;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyConfigurationEncrypter implements PolicyConfigurationEncrypter {

  private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyConfigurationEncrypter.class);

  private final RuntimeEncrypter runtimeEncrypter;
  private final boolean isSensitiveOnlyEnabled;

  public DefaultPolicyConfigurationEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled) {
    this.runtimeEncrypter = runtimeEncrypter;
    this.isSensitiveOnlyEnabled = isSensitiveOnlyEnabled;
  }

  @Override
  public PolicyConfigurationEncryptionResult encryptConfiguration(PolicyDefinition policyDefinition,
                                                                  PolicySpecification policySpecification) {

    Map<String, Object> templateValues = new HashMap<>();
    Map<String, Object> configurationValues = new HashMap<>();
    Map<String, Object> configFile = new HashMap<>();

    if (policySpecification.isValid()) {

      PolicyTypeEncrypters encrypters =
          new PolicyTypeEncrypters(runtimeEncrypter, isSensitiveOnlyEnabled, policySpecification.getConfiguration());

      policyDefinition.getConfigurationData().getConfiguration().forEach((key, value) -> {

        PolicyTypeEncrypter encrypter = encrypters.getEncrypter(key);

        EncryptedValueResult encrypted = encrypter.encrypt(key, value);

        templateValues.put(key, encrypted.getTemplateValue());
        configurationValues.put(key, encrypted.getConfigurationValue());
        encrypted.getConfigFileValue().ifPresent(o -> configFile.put(key, o));
      });

      templateValues.put(PROPERTY_ENCRYPTED, !configFile.isEmpty());
    } else {
      LOGGER.warn("Encryption of policy {} is disabled, since YAML file is absent or invalid.", policyDefinition.getName());
    }

    return new PolicyConfigurationEncryptionResult(templateValues,
                                                   new PolicyConfiguration(configurationValues),
                                                   configFile);
  }
}
