/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.notification;

import static java.util.stream.Collectors.toList;

import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import org.mule.runtime.api.notification.NotificationListener;

import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

/**
 * Collection of suppliers that will provide notification listeners for policy's deployment
 */
public class PolicyNotificationListenerSuppliers {

  private List<PolicyNotificationListenerSupplier> listenerSuppliers = new ArrayList<>();

  public void add(PolicyNotificationListenerSupplier supplier) {
    this.listenerSuppliers.add(supplier);
  }

  public List<NotificationListener> supply(ApiImplementation implementation, PolicyDefinition policyDefinition,
                                           PolicySpecification policySpecification) {
    return listenerSuppliers.stream()
        .map(supplier -> supplier.supply(implementation, policyDefinition, policySpecification))
        .flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty))
        .collect(toList());
  }
}
