/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection.change;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;

/**
 * Represents the action that must be taken to consolidate the current status with with the desired status.
 */
public abstract class ChangeType {

  private final PolicyDefinition definition;

  public ChangeType(PolicyDefinition definition) {
    this.definition = definition;
  }

  public abstract void accept(ChangeTypeVisitor visitor);

  public PolicyDefinition getDefinition() {
    return definition;
  }
}
