/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.offline;

import com.mulesoft.anypoint.tests.DescriptiveProbe;
import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.mule.runtime.gw.api.PolicyFolders;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyListener;
import com.mulesoft.mule.runtime.gw.policies.offline.OfflinePolicyWatcher;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentService;
import com.mulesoft.mule.runtime.gw.reflection.Inspector;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemPropertyTemporaryFolder;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class OfflinePolicyWatcherTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemPropertyTemporaryFolder muleHome = new SystemPropertyTemporaryFolder("mule.home");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private PolicyDeploymentService policyDeploymentService;
    private MockLogger logger;

    @Before
    public void setUp() throws MuleException {
        this.policyDeploymentService = (PolicyDeploymentService)Mockito.mock(PolicyDeploymentService.class);
        OfflinePolicyWatcher offlinePolicyWatcher = new OfflinePolicyWatcher(this.policyDeploymentService);
        this.overrideLogger(offlinePolicyWatcher);
        offlinePolicyWatcher.initialise();
        offlinePolicyWatcher.start();
    }

    @Test
    public void newFileIsDetected() throws URISyntaxException, IOException {
        File offlineDefinitionFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json");
        FileUtils.copyFile((File)this.definitionFile(), (File)offlineDefinitionFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)Matchers.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    @Test
    public void invalidDefinitionNotDeployed() throws URISyntaxException, IOException, InterruptedException {
        File offlineDefinitionFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json");
        FileUtils.copyFile((File)this.invalidDefinitionFile(), (File)offlineDefinitionFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService})));
    }

    @Test
    public void invalidExtensionInNewFileIsIgnored() throws URISyntaxException, IOException, InterruptedException {
        File invalidFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy.xml");
        FileUtils.copyFile((File)this.invalidExtensionFile(), (File)invalidFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            TestCase.assertTrue((boolean)this.logger.lines().stream().anyMatch(logLine -> logLine.toString().contains("Invalid extension")));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    @Test
    public void modificationIsDetected() throws URISyntaxException, IOException {
        FileUtils.copyFile((File)this.definitionFile(), (File)new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json"));
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)Matchers.any())));
        FileUtils.copyFile((File)this.updatedDefinitionFile(), (File)new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json"));
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService, (VerificationMode)Mockito.times((int)2))).newPolicy((PolicyDefinition)Matchers.any());
            ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy((PolicyDefinition)Matchers.anyObject());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    @Test
    public void removeIsDetected() throws URISyntaxException, IOException {
        File offlineDefinitionFile = new File(PolicyFolders.getOfflinePoliciesFolder(), "policy-definition.json");
        FileUtils.copyFile((File)this.definitionFile(), (File)offlineDefinitionFile);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)Matchers.any())));
        boolean deleted = offlineDefinitionFile.delete();
        TestCase.assertTrue((boolean)deleted);
        new PollingProber(2000L, 200L).check((Probe)new DescriptiveProbe(() -> {
            ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).newPolicy((PolicyDefinition)Matchers.any());
            ((PolicyDeploymentService)Mockito.verify((Object)this.policyDeploymentService)).removePolicy("policy-definition");
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.policyDeploymentService});
        }));
    }

    private File definitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/full-definition.json").toURI());
    }

    private File updatedDefinitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/updated-definition.json").toURI());
    }

    private File invalidDefinitionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/json/offline-invalid-field-definition.json").toURI());
    }

    private File invalidExtensionFile() throws URISyntaxException {
        return new File(((Object)((Object)this)).getClass().getResource("/templates/template.xml").toURI());
    }

    private void overrideLogger(OfflinePolicyWatcher offlinePolicyWatcher) {
        this.logger = new MockLogger();
        OfflinePolicyListener offlinePolicyListener = (OfflinePolicyListener)new Inspector((Object)offlinePolicyWatcher).read("listener");
        VariableOverride.overrideLogger().in((Object)offlinePolicyListener).with((Object)this.logger);
    }
}

