/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.pointcut;

import com.mulesoft.anypoint.tests.logger.MockLogger;
import com.mulesoft.anypoint.tests.logger.TraceLine;
import com.mulesoft.mule.runtime.gw.policies.pointcut.ApiPointcutAdapter;
import com.mulesoft.mule.runtime.gw.policies.pointcut.PointcutTestUtils;
import com.mulesoft.mule.runtime.gw.reflection.VariableOverride;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ApiPointcutAdapterTestCase
extends AbstractMuleTestCase {
    private static final String POLICY_NAME = "name";
    private static final String FLOW_NAME = "FlowName";
    private static final String FLOW_NAME_LOWER_CASE = "flowname";
    private static final String FLOW_NAME_2 = "otherFlowName";
    private ApiPointcutAdapter pointcut;
    private MockLogger logger;

    @Before
    public void setUp() {
        this.logger = new MockLogger();
        this.pointcut = new ApiPointcutAdapter(POLICY_NAME, FLOW_NAME);
        VariableOverride.overrideLogger().in((Object)this.pointcut).with((Object)this.logger);
    }

    @Test
    public void apiMatchesListenerParameters() {
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters(FLOW_NAME);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Executing flow matches API's flow {} for policy {}", new Object[]{FLOW_NAME, POLICY_NAME})));
    }

    @Test
    public void apiMatchesRequestParameters() {
        PolicyPointcutParameters parameters = PointcutTestUtils.requesterPointcutParameters(FLOW_NAME);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertTrue((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Executing flow matches API's flow {} for policy {}", new Object[]{FLOW_NAME, POLICY_NAME})));
    }

    @Test
    public void differentFlowNamesDoesNotMatch() {
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters(FLOW_NAME_2);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Executing flow {} does not match API's flow {} for policy {}", new Object[]{FLOW_NAME_2, FLOW_NAME, POLICY_NAME})));
    }

    @Test
    public void differentFlowNameCasingDoesNotMatch() {
        PolicyPointcutParameters parameters = PointcutTestUtils.listenerPointcutParameters(FLOW_NAME_LOWER_CASE);
        boolean matches = this.pointcut.matches(parameters);
        Assert.assertFalse((boolean)matches);
        Assert.assertThat((Object)this.logger.lines(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.logger.lines().get(0), (Matcher)Matchers.is((Object)new TraceLine("Executing flow {} does not match API's flow {} for policy {}", new Object[]{FLOW_NAME_LOWER_CASE, FLOW_NAME, POLICY_NAME})));
    }
}

